
*===================================================================================*
* TTULO DE LA SINTAXIS:*
* Clculo de la Tasa de Vehculos Matriculados por cada 1000 habitantes*
* OPERACIN ESTADSTICA:*
* Anuario de Transporte - Vehculos Matriculados*
*DIRECCIN TCNICA RESPONSABLE:*
* Direccin de Estadsticas Econmicas (DECON)*
* ENTIDAD EJECUTORA:*
* Instituto Nacional de Estadstica y Censos (INEC)*
*===================================================================================*
* Fecha de elaboracin:        29 de Septiembre del 2017*
* Fecha ltima modificacin:   29 de Septiembre del 2017*
*===================================================================================*
* Elaborado por:*
* Unidad de Gestin de Estadsticas Estructurales (GESE)*.

*Instrucciones:.
*1.- Descarga la base de datos de vehculos matriculados "2016_Vehculos Matriculados_BDD" en formato SPSS de la pgina web del INEC (http://www.ecuadorencifras.gob.ec//transporte/).
*2.- Guardar y abrir la base de datos "2016_Vehculos Matriculados_BDD".

dataset name VEHICULOS.
dataset copy 2016_Vehculos Matriculados_BDD.
dataset activate VEHICULOS.

**********************************************************************************************************************.
****TASA DE VEHCULOS MATRICULADOS POR CADA MIL HABITANTES A NIVEL PROVINCIAL***.
**********************************************************************************************************************.

***Creando variable nmero de vehculos***.
compute NVEHICULOS=1.
formats NVEHICULOS (F5.0).
variable labels NVEHICULOS 'Nmero de vehculos'.
execute.

***Agregando la base de datos a nivel de provincia***.
dataset declare TASA_VEHICULOS.
aggregate
  /outfile='TASA_VEHICULOS'
  /break=PROVINCIA
  /NVEHICULOS=SUM(NVEHICULOS).

**Utilizacin de la base de datos agregada***.
dataset activate TASA_VEHICULOS.

***Preparando la base para el clculo del indicador***.
variable labels NVEHICULOS 'Nmero de vehculos matriculados'.
formats NVEHICULOS (F10.0).
execute.

if (PROVINCIA=1) POBLACION=824646.
if (PROVINCIA=2) POBLACION=203344.
if (PROVINCIA=3) POBLACION=263048.
if (PROVINCIA=4) POBLACION=181265.
if (PROVINCIA=5) POBLACION=463819.
if (PROVINCIA=6) POBLACION=506325.
if (PROVINCIA=7) POBLACION=680845.
if (PROVINCIA=8) POBLACION=608906.
if (PROVINCIA=9) POBLACION=4146996.
if (PROVINCIA=10) POBLACION=451476.
if (PROVINCIA=11) POBLACION=500794.
if (PROVINCIA=12) POBLACION=876912.
if (PROVINCIA=13) POBLACION=1510375.
if (PROVINCIA=14) POBLACION=179406.
if (PROVINCIA=15) POBLACION=122838.
if (PROVINCIA=16) POBLACION=102655.
if (PROVINCIA=17) POBLACION=3003799.
if (PROVINCIA=18) POBLACION=564260.
if (PROVINCIA=19) POBLACION=110296.
if (PROVINCIA=20) POBLACION=30172.
if (PROVINCIA=21) POBLACION=210532.
if (PROVINCIA=22) POBLACION=153269.
if (PROVINCIA=23) POBLACION=426910.
if (PROVINCIA=24) POBLACION=367235.
execute.

variable labels POBLACION 'Proyecin poblacional provincial 2016'.
formats POBLACION (F10.0).
execute.

compute POBLACION_1000=(POBLACION/1000).
variable labels POBLACION_1000 'Poblacin/1000'.
formats POBLACION_1000 (F10.0).
execute.

compute TMV=(NVEHICULOS/POBLACION_1000).
variable labels TMV 'Tasa de vehculos matriculados por cada 1000 habitantes'.
formats TMV (F5.0).
execute.

***Tabulado: Tasa de Vehculos Matriculados por Provincias***.
tables
/observation= NVEHICULOS POBLACION_1000 TMV
/table= PROVINCIA BY NVEHICULOS + POBLACION_1000 + TMV
/statistics=sum.
execute.

dataset close TASA_VEHICULOS.

********************************************************************************************************************.
****TASA DE VEHCULOS MATRICULADOS POR CADA MIL HABITANTES A NIVEL NACIONAL***.
********************************************************************************************************************.

*Usando base de datos "2016_Vehculos Matriculados_BDD"**.
dataset activate VEHICULOS.

compute NACIONAL=1.
variable labels NACIONAL 'Nacional'.
formats NACIONAL (F1.0).
execute.

***Creando variable nmero de vehculos***.
compute NVEHICULOS=1.
formats NVEHICULOS (F5.0).
variable labels NVEHICULOS 'Nmero de vehculos'.
execute.

***Agregando la base de datos a nivel nacional***.
dataset declare TASA_VEHICULOS_N.
aggregate
  /outfile='TASA_VEHICULOS_N'
  /break=NACIONAL
  /NVEHICULOS=SUM(NVEHICULOS).

**Utilizacin de la base de datos agregada***.
dataset activate TASA_VEHICULOS_N.

***Preparabdo la base para el clculo del indicador***.
variable labels NVEHICULOS 'Nmero de vehculos matriculados'.
formats NVEHICULOS (F10.0).
execute.

compute POBLACION=16528730.
variable labels POBLACION 'Proyecin poblacional nacional 2016'.
formats POBLACION (F10.0).
execute.

compute POBLACION_1000=(POBLACION/1000).
variable labels POBLACION_1000 'Poblacin/1000'.
formats POBLACION_1000 (F10.0).
execute.

compute TMV=(NVEHICULOS/POBLACION_1000).
variable labels TMV 'Tasa de vehculos matriculados por cada 1000 habitantes'.
formats TMV (F5.0).
execute.

***Tabulado: Tasa de Vehculos Matriculados Nacional***.
tables
/observation= NVEHICULOS POBLACION_1000 TMV
/table= NACIONAL BY NVEHICULOS + POBLACION_1000 + TMV
/statistics=sum.
execute.

dataset close TASA_VEHICULOS_N.










